/*
 * Decompiled with CFR 0.152.
 */
package io.github.queerbric.pride.shape;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.queerbric.pride.data.PrideData;
import io.github.queerbric.pride.shape.PrideFlagShape;
import it.unimi.dsi.fastutil.ints.IntList;
import net.minecraft.class_332;
import org.jetbrains.annotations.NotNull;

public record VerticalPrideFlagShape(IntList colors) implements PrideFlagShape
{
    public static final MapCodec<VerticalPrideFlagShape> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PrideData.COLOR_LIST_CODEC.fieldOf("colors").forGetter(VerticalPrideFlagShape::colors)).apply((Applicative)instance, VerticalPrideFlagShape::new));

    @Override
    @NotNull
    public PrideFlagShape.Type type() {
        return PrideFlagShape.VERTICAL_STRIPES_TYPE;
    }

    @Override
    public void render(class_332 graphics, int x, int y, int width, int height) {
        float currentX = x;
        float sw = (float)width / (float)this.colors.size();
        for (int i = 0; i < this.colors.size(); ++i) {
            int color = this.colors.getInt(i);
            graphics.method_25294((int)currentX, y, (int)(currentX + sw), y + height, color);
            currentX += sw;
        }
    }
}

